<!DOCTYPE html>
<html lang="en" dir="ltr">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>Ready Ride - Ride Sharing App</title>
    <meta name="description" content="Ready Ride - Ride Sharing App" />
    <link rel="shortcut icon" href="assets/images/logo/favicon.svg" type="image/f-icon" />

    <!-- Remix Icon -->
    {{-- <link rel="stylesheet" href="{{ 'assets/css/remixicon.css'}}"> --}}
    <link rel="stylesheet" href="assets/css/remixicon.css" />
    <!-- bootstraph -->
    {{-- <link rel="stylesheet" href="{{ 'assets/css/bootstrap.css'}}"> --}}
    <link rel="stylesheet" href="assets/css/bootstrap.min.css" />
    <!-- Swiper Slider -->
    {{-- <link rel="stylesheet" href="{{ 'assets/css/swiper-bundle.min.css'}}"> --}}
    <link rel="stylesheet" href="assets/css/swiper-bundle.min.css" />
    <!-- Aos Animation -->
    {{-- <link rel="stylesheet" href="{{ 'assets/css/aos.css'}}"> --}}
    <link rel="stylesheet" href="assets/css/aos.css" />
    <!-- User's CSS Here -->
    {{-- <link rel="stylesheet" href="{{ 'assets/css/style.css'}}"> --}}
    <link rel="stylesheet" href="assets/css/style.css" />
</head>

<body>
    <!-- Header Start -->
    <header class="header">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    @php
                        $header = $webSettings->firstWhere('key', 'header')->decoded_value ?? null;
                    @endphp

                    <nav class="nav d-block p-0 m-0">
                        <div class="header__wrapper">
                            <div class="header__logo">
                                <a href="index.html">
                                    @php
                                        $logoPath = Str::startsWith($header->logo, 'assets/')
                                            ? asset($header->logo)
                                            : asset('storage/' . $header->logo);
                                    @endphp
                                    <img src="{{ $logoPath }}" alt="logo" />
                                </a>
                            </div>
           
                            <div class="header__menu">
                                    <ul class="main__menu">
                                        <li><a class="active" href="index.html">Home</a></li>
                                        <li>
                                            <a href="#">About us</a>
                                        </li>
                                        <li><a href="#">Contact us</a></li>
                                        <li><a href="#">Privacy policy</a></li>

                                    </ul>
                                </div>
                                <!-- Header Menu End -->

                                <div class="header__right">
                                    <a href="#" class="rs-btn rs-btn-primary">Get The App</a>
                                    <a href="{{ route('dashboard')}}" class="rs-btn rs-btn-white">Go to Admin</a>
                                    <!-- Header Toggle -->
                                    <div class="header__toggle" data-bs-toggle="offcanvas" data-bs-target="#headerOffcanvas">
                                        <div class="toggle__bar"></div>
                                    </div>
                                </div>
                                <!-- Header Right List End -->
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </header>
    <!-- Header End -->

    <!-- Banner Section Start -->
    @php
        $banner = $webSettings->firstWhere('key', 'banner')->decoded_value ?? null;
    @endphp

    <section class="banner__section">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="hero__text" data-aos="fade-up" data-aos-duration="700">
                        <h4 class="subtitle">
                            <span class="img__group">
                                @if (!empty($banner->image_group))
                                    @foreach ($banner->image_group as $img)
                                        @php
                                            $imgPath = Str::startsWith($img->img, 'assets/')
                                                ? asset($img->img)
                                                : asset('storage/' . $img->img);
                                        @endphp

                                        <img src="{{ $imgPath }}" alt="avatar" />
                                    @endforeach
                                @endif
                            </span>
                            <span class="star">
                                @php
                                    $rating = $banner->ratings ?? 0;
                                    $fullStars = floor($rating);
                                    $halfStar = $rating - $fullStars >= 0.5 ? 1 : 0;

                                @endphp

                                @for ($i = 0; $i < $fullStars; $i++)
                                    <i class="ri-star-fill"></i>
                                @endfor

                                @if ($halfStar)
                                    <i class="ri-star-half-fill"></i>
                                @endif
                            </span>

                            {{ $banner->reviews ?? '0 Reviews' }}
                        </h4>


                        <h1 class="title">{!! $banner->title ?? '' !!}</h1>

                        <p class="desc">{{ $banner->description ?? '' }}</p>

                        <div class="btn__group">
                            @if (!empty($banner->app_store))
                                @foreach ($banner->app_store as $app)
                                    @php
                                        $thumbPath = Str::startsWith($app->thumb, 'assets/')
                                            ? asset($app->thumb)
                                            : asset('storage/' . $app->thumb);
                                    @endphp
                                    <a href="{{ $app->link ?? '#' }}">
                                        <img src="{{ $thumbPath ?? '' }}" alt="app" />
                                    </a>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="banner__thumb" data-aos="fade-up" data-aos-duration="800">
                        @php
                            $bannerPath = Str::startsWith($banner->banner_thumb, 'assets/')
                                ? asset($banner->banner_thumb)
                                : asset('storage/' . $banner->banner_thumb);
                        @endphp
                        <img src="{{ $bannerPath ?? '' }}" alt="banner-thumb" />
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Banner Section End -->

    <!-- Why Choose Section Start -->
    @php
        $chooseSection = $webSettings->firstWhere('key', 'choose_section')->decoded_value ?? null;
    @endphp

    <section class="choose__section py-60 py-sm-50">
        <div class="container">
            <div class="row align-items-center gy-5">
                <!-- Image / Thumbnail -->
                <div class="col-lg-5 col-md-6">
                    <div class="choose__thumb" data-aos="fade-up" data-aos-duration="800">
                        @php
                            $choosePath = Str::startsWith($chooseSection->choose_thumb, 'assets/')
                                ? asset($chooseSection->choose_thumb)
                                : asset('storage/' . $chooseSection->choose_thumb);
                        @endphp
                        <img src="{{ $choosePath ?? 'assets/images/choose/choose-thumb.jpg' }}" alt="choose" />
                    </div>
                </div>

                <!-- Title, Description & List Items -->
                <div class="col-lg-7 col-md-6">
                    <div class="section__title mb-25" data-aos="fade-up" data-aos-duration="700">
                        <h2 class="title">
                            {!! $chooseSection->title ?? 'Built for <br /> Seamless Journeys' !!}
                        </h2>
                        <p class="desc">
                            {{ $chooseSection->description ?? 'Customers can utilize the customer app to conveniently browse products...' }}
                        </p>
                    </div>

                    <!-- List Items -->
                    <ul class="list__item" data-aos="fade-up" data-aos-duration="800">
                        @if (!empty($chooseSection->list_item))
                            @foreach ($chooseSection->list_item as $item)
                                @php
                                    $itemPath = Str::startsWith($item->thumb, 'assets/')
                                        ? asset($item->thumb)
                                        : asset('storage/' . $item->thumb);
                                @endphp
                                <li>
                                    <div class="icon">
                                        <img src="{{ $itemPath ?? 'assets/images/choose/default-icon.png' }}"
                                            alt="icon" />
                                    </div>
                                    {{ $item->name ?? 'Item Name' }}
                                </li>
                            @endforeach
                        @endif
                    </ul>
                </div>
            </div>
        </div>
    </section>

    @php
        $app = $webSettings->firstWhere('key', 'app_section')->decoded_value ?? null;
    @endphp

    <section class="app__section py-60 py-sm-50">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    @php
                        $appPath = Str::startsWith($app->background_image, 'assets/')
                            ? asset($app->background_image)
                            : asset('storage/' . $app->background_image);
                    @endphp
                    <div class="app__wrapper"
                        style="background-image: url('{{ $appPath ?? 'assets/images/apps/apps-banner.jpg' }}');"
                        data-aos="fade-up" data-aos-duration="800">
                        <div class="content__area">
                            <div class="section__title mb-25 text-white">
                                <h2 class="title">
                                    {!! $app->title ?? '' !!}
                                </h2>
                                <p class="desc">
                                    {{ $app->description ?? 'Take control of your travel with flexible ride options, real-time tracking, and simple payments — all in one app.' }}
                                </p>
                            </div>

                            <div class="appArea__flex">
                                @if (!empty($app->app_store))
                                    @foreach ($app->app_store as $store)
                                        <div class="app__area">
                                            <div class="qr__code">
                                                {{-- {!! QrCode::size(120)->generate($store->link ?? url('http://127.0.0.1:8000/dashboard')) !!} --}}
                                            </div>


                                            <div class="content">
                                                <div class="apps">
                                                    @php
                                                        $storePath = Str::startsWith($store->thumb, 'assets/')
                                                            ? asset($store->thumb)
                                                            : asset('storage/' . $store->thumb);
                                                    @endphp
                                                    <img src="{{ $storePath ?? 'assets/images/apps/app-store.png' }}"
                                                        alt="app" />
                                                </div>
                                                <a href="{{ $store->link ?? 'http://127.0.0.1:8000/dashboard' }}"
                                                    class="rs-btn rs-btn-primary">Download</a>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>

                        <div class="app__thumb">
                            @php
                                $appPath = Str::startsWith($app->app_thumb, 'assets/')
                                    ? asset($app->app_thumb)
                                    : asset('storage/' . $app->app_thumb);
                            @endphp
                            <img src="{{ $appPath ?? 'assets/images/apps/apps-thumb.png' }}" alt="apps" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- App Section End -->

    <!-- Feature Section Start -->

    @php
        $feature = $webSettings->firstWhere('key', 'feature_section')->decoded_value ?? null;
    @endphp

    <section class="feature__section py-60 py-sm-50">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    @php
                        $featurePath = Str::startsWith($feature->background_image, 'assets/')
                            ? asset($feature->background_image)
                            : asset('storage/' . $feature->background_image);
                    @endphp
                    <div class="feature__wrapper"
                        style="background-image: url('{{ $featurePath ?? 'assets/images/feature/feature-bg.png' }}');"
                        data-aos="fade-up" data-aos-duration="800">
                        <div class="section__title text-white text-center mb-0">
                            <h4 class="title how-ready">{!! $feature->title ?? 'How Ready To Ride Works' !!}</h4>
                            <h5 class="subtitle">{{ $feature->sub_title ?? 'Book, Ride, Arrive!' }}</h5>
                            <p class="desc">
                                {{ $feature->description ?? 'Our ride-share app makes transportation easy, convenient, and reliable for everyone. Follow these simple steps to get started today!' }}
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row" data-aos="fade-up" data-aos-duration="800">
                @if (!empty($feature->feature_card))
                    @foreach ($feature->feature_card as $card)
                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <div class="featureCard">
                                <div class="feature__head">
                                    <div class="number">{{ $card->number ?? '' }}</div>
                                    <div class="icon">
                                        @php
                                            $cardPath = Str::startsWith($card->icon_image, 'assets/')
                                                ? asset($card->icon_image)
                                                : asset('storage/' . $card->icon_image);
                                        @endphp
                                        <img src="{{ $cardPath ?? 'assets/images/feature/feature-icon-01.png' }}"
                                            alt="icon" />
                                    </div>
                                </div>
                                <div class="content">
                                    <h4>{{ $card->content_title ?? '' }}</h4>
                                    <p>{{ $card->content_subtitle ?? '' }}</p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>

    <!-- Feature Section End -->

    <!-- Discover Section Start -->
    @php
        $discover = $webSettings->firstWhere('key', 'discover_section')->decoded_value ?? null;
    @endphp

    <section class="discover__section py-60 py-sm-50">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    @php
                        $discoverPath = Str::startsWith($discover->background_image, 'assets/')
                            ? asset($discover->background_image)
                            : asset('storage/' . $discover->background_image);
                    @endphp
                    <div class="discover__wrapper"
                        style="background-image: url('{{ $discoverPath ?? 'assets/images/discover/discover-banner.jpg' }}');"
                        data-aos="fade-up" data-aos-duration="800">
                        <div class="content__area">
                            <div class="section__title mb-0 text-white">
                                <h2 class="title">{!! $discover->title ?? 'Discover, <br /> Ride & Arrive with Ease!' !!}</h2>
                                <p class="desc mt-25">
                                    {{ $discover->description ?? 'From quick commutes to premium rides, get everywhere you need to go—safely, affordably, and on time. Book, track, and enjoy hassle-free rides with seamless in-app payments.' }}
                                </p>
                            </div>
                        </div>
                        <div class="discover__thumb">
                            <img src="{{ $discover->discover_thumb ?? 'assets/images/discover/discover-thumb.png' }}"
                                alt="discover" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Discover Section End -->

    <!-- Who we are Section Start -->
    @php
        $whoWeAre = $webSettings->firstWhere('key', 'who_we_are')->decoded_value ?? null;
    @endphp

    <section class="whoWeare__section py-60 py-sm-50">
        <div class="container">
            <div class="row">
                @if (!empty($whoWeAre->who))
                    @foreach ($whoWeAre->who as $index => $item)
                        <div class="col-lg-{{ $index == 0 ? 5 : 7 }} col-md-6">
                            <div class="wrapper__area {{ $index == 1 ? 'pt-90' : '' }}" data-aos="fade-up"
                                data-aos-duration="800">
                                @if ($index == 0)
                                    <div class="thumb">
                                        @php
                                            $item1Path = Str::startsWith($item->thumb_1, 'assets/')
                                                ? asset($item->thumb_1)
                                                : asset('storage/' . $item->thumb_1);
                                        @endphp
                                        <img src="{{ $item1Path ?? 'assets/images/who-we-are/thumb-01.jpg' }}"
                                            alt="thumb" />
                                    </div>
                                @endif

                                <div class="section__title mb-0 {{ $index == 1 ? 'mb-25' : 'mt-25' }}">
                                    <h2 class="title text-primary">
                                        {{ $index == 0 ? $item->title_1 : $item->title_2 }}
                                    </h2>
                                    <p class="desc">
                                        {{ $index == 0 ? $item->description_1 : $item->description_2 }}
                                    </p>
                                </div>

                                @if ($index == 1)
                                    <div class="thumb thumb__2">
                                        @php
                                            $item2Path = Str::startsWith($item->thumb_2, 'assets/')
                                                ? asset($item->thumb_2)
                                                : asset('storage/' . $item->thumb_2);
                                        @endphp
                                        <img src="{{ $item->thumb_2 ?? 'assets/images/who-we-are/thumb-01.jpg' }}"
                                            alt="thumb" />
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>

    <!-- Who we are Section End -->

    <!-- CtaBox Section Start -->
    @php
        $register = $webSettings->firstWhere('key', 'register_section')->decoded_value ?? null;
    @endphp

    <section class="ctaBox__section py-60 py-sm-50">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    @php
                        $registerPath = Str::startsWith($register->background_image, 'assets/')
                            ? asset($register->background_image)
                            : asset('storage/' . $register->background_image);
                    @endphp
                    <div class="cta__wrapper" style="background-image: url('{{ $registerPath ?? '' }}');"
                        data-aos="fade-up" data-aos-duration="800">
                        @if (!empty($register->thumb))
                            <div class="cta__thumb">
                                @php
                                    $thumbPath = Str::startsWith($register->thumb, 'assets/')
                                        ? asset($register->thumb)
                                        : asset('storage/' . $register->thumb);
                                @endphp
                                <img src="{{ $thumbPath ?? '' }}" alt="cta" />
                            </div>
                        @endif

                        <div class="content__area">
                            <div class="section__title mb-0 text-white">
                                @if (!empty($register->sub_title))
                                    <h4 class="subtitle">{{ $register->sub_title }}</h4>
                                @endif

                                @if (!empty($register->title))
                                    <h2 class="title">{!! $register->title !!}</h2>
                                @endif

                                @if (!empty($register->description))
                                    <p class="desc">{{ $register->description }}</p>
                                @endif
                            </div>

                            @if (!empty($register->button))
                                <div class="btn__group">
                                    @foreach ($register->button as $btn)
                                        <a href="{{ $btn->button_link_1 ?? '#' }}" class="rs-btn rs-btn-primary">
                                            {{ $btn->button_name_1 ?? 'Click Here' }}
                                        </a>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CtaBox Section End -->

    <!-- Testimonial Section Start -->
    @php
        $testimonial = $webSettings->firstWhere('key', 'testimonial_section')->decoded_value ?? null;
    @endphp

    <section class="testimonial__section py-60 py-sm-50">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="section__title text-center" data-aos="fade-up" data-aos-duration="800">
                        <h2 class="title">{{ $testimonial->title ?? 'Our User Review' }}</h2>
                        <p>{{ $testimonial->description ?? '' }}</p>
                    </div>
                </div>

                @if (!empty($testimonial->testimonial_content))
                    <div class="col-12">
                        <div class="testimonial__inner" data-aos="fade-up" data-aos-duration="800">
                            <div class="swiper testimonial__slider">
                                <div class="swiper-wrapper">
                                    @foreach ($testimonial->testimonial_content as $item)
                                        @php
                                            $title = $item->title_1 ?? ($item->title_2 ?? ($item->title_3 ?? ''));
                                            $rating = $item->rating_1 ?? ($item->rating_2 ?? ($item->rating_3 ?? 0));
                                            $description =
                                                $item->description_1 ??
                                                ($item->description_2 ?? ($item->description_3 ?? ''));
                                            $date =
                                                $item->date_1 ??
                                                ($item->date_2 ?? ($item->date_3 ?? now()->format('d/m/Y')));
                                        @endphp

                                        <div class="swiper-slide">
                                            <div class="testimonialCard">
                                                <div class="avatar">
                                                    @php
                                                        $avatarRaw =
                                                            $item->avatar_image_1 ??
                                                            ($item->avatar_image_2 ?? ($item->avatar_image_3 ?? ''));

                                                        if ($avatarRaw) {
                                                            $avatarPath = Str::startsWith($avatarRaw, 'assets/')
                                                                ? asset($avatarRaw)
                                                                : asset('storage/' . $avatarRaw);
                                                        } else {
                                                            $avatarPath = asset('assets/images/default-avatar.png'); // fallback avatar
                                                        }
                                                    @endphp
                                                    <img src="{{ $avatarPath }}" alt="avatar" />
                                                </div>
                                                <div class="testimonialCard__content">
                                                    <div class="header__flex">
                                                        <div class="">
                                                            <h5 class="title">{{ $title }}</h5>
                                                            <div class="rating">
                                                                @for ($i = 1; $i <= 5; $i++)
                                                                    <i
                                                                        class="ri-star-fill {{ $i <= $rating ? 'active' : '' }}"></i>
                                                                @endfor
                                                                {{ number_format($rating, 1) }}
                                                            </div>
                                                        </div>
                                                        <div class="date">
                                                            {{ \Carbon\Carbon::parse($date)->format('d/m/Y') }}</div>
                                                    </div>
                                                    <p>{{ $description }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            <!-- Swiper Navigation -->
                            <div class="swiper__navigation swiper-slide">
                                <div class="testimonial-swipe-prev swiper-button-prev">
                                    <i class="ri-arrow-left-circle-line"></i>
                                </div>
                                <div class="testimonial-swipe-next swiper-button-next">
                                    <i class="ri-arrow-right-circle-line"></i>
                                </div>
                            </div>

                            <!-- Swiper Pagination -->
                            <div class="swiper__pagination">
                                <div class="testimonial-pagination"></div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </section>

    <!-- Testimonial Section End -->

    <!-- Accordion Section Start -->
    @php
        $accordian = $webSettings->firstWhere('key', 'accordian_section')->decoded_value ?? null;
        $accordionItems = $accordian->accordian_items ?? [];
    @endphp

    <section class="accordion__section py-60 py-sm-50">
        <div class="container">
            <div class="row align-items-center gy-4">
                <div class="col-lg-6 col-md-6">
                    <div class="accordion__thumb" data-aos="fade-up" data-aos-duration="800">
                        @php
                            $accordianPath = Str::startsWith($accordian->accordian_thumb, 'assets/')
                                ? asset($accordian->accordian_thumb)
                                : asset('storage/' . $accordian->accordian_thumb);
                        @endphp
                        <img src="{{ $accordianPath }}" alt="faq" />
                    </div>
                </div>
                <div class="col-lg-6 col-md-6" data-aos="fade-up" data-aos-duration="800">
                    <div class="section__title mb-25">
                        <h2 class="title">
                            {!! $accordian->title !!} <br />
                            <span>{{ $accordian->sub_title }}</span>
                        </h2>
                    </div>
                    <div class="accordion__wrapper">
                        <div class="accordion" id="accordionExample">
                            @foreach ($accordionItems as $index => $item)
                                @php
                                    $itemTitle = $item->{'title_' . ($index + 1)} ?? '';
                                    $itemContent = $item->{'content_' . ($index + 1)} ?? '';
                                    $collapseId = 'collapse' . ($index + 1);
                                    $headingId = 'heading' . ($index + 1);
                                @endphp
                                <div class="accordion__item">
                                    <div class="accordion__header" id="{{ $headingId }}">
                                        <button class="accordion-button {{ $index > 0 ? 'collapsed' : '' }}"
                                            type="button" data-bs-toggle="collapse"
                                            data-bs-target="#{{ $collapseId }}"
                                            aria-expanded="{{ $index === 0 ? 'true' : 'false' }}"
                                            aria-controls="{{ $collapseId }}">
                                            {{ $itemTitle }}
                                        </button>
                                    </div>
                                    <div id="{{ $collapseId }}"
                                        class="accordion-collapse collapse {{ $index === 0 ? 'show' : '' }}"
                                        aria-labelledby="{{ $headingId }}" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <div class="accordion__content">
                                                <p>{{ $itemContent }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Accordion Section End -->

    <!-- Footer Section Start -->
    @php
        $footer = $webSettings->firstWhere('key', 'footer')->decoded_value ?? null;
        $footerLogo = $footer->footer_logo ?? 'assets/images/logo/logo-white.svg';
        $description = $footer->description ?? '';
        $footerText = $footer->footer_text ?? '';
        $footerLinks = $footer->footer_link ?? [];
        $contactLinks = $footer->link ?? [];
        $socialIcons = $footer->social_icon ?? [];
    @endphp

    <footer class="footer__section">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center">
                    <a href="#" class="footer__logo">
                        <img src="{{ asset($footerLogo) }}" alt="logo" />
                    </a>

                    @if ($description)
                        <div class="footer__content">
                            <p>{{ $description }}</p>

                            @if (count($contactLinks))
                                <div class="link mb-3">
                                    @foreach ($contactLinks as $item)
                                        @php
                                            $link = $item->link_1 ?? ($item->link_2 ?? '');
                                            $icons = $item->link_icon_1 ?? ($item->link_icon_2 ?? '');

                                            $icon = Str::startsWith($icons, 'assets/')
                                                ? asset($icons)
                                                : asset('storage/' . $icons);
                                        @endphp

                                        @if ($link)
                                            <a
                                                href="{{ Str::startsWith($link, ['http', 'mailto', 'tel']) ? $link : 'tel:' . $link }}">
                                                @if ($icon)
                                                    <img src="{{ $icon }}" alt="icon" />
                                                @endif
                                                {{ $link }}
                                            </a>
                                        @endif
                                    @endforeach
                                </div>
                            @endif

                            @if (!empty($socialIcons))
                                <div class="social__icon mb-3">
                                    <div class="icon__list">

                                        @foreach ($socialIcons as $item)
                                            @php
                                                $iconKey = collect($item)->keys()->first();
                                                $linkKey = collect($item)->keys()->last();

                                                $iconPath = Str::startsWith($item->$iconKey, 'assets/')
                                                    ? asset($item->$iconKey)
                                                    : asset('storage/' . $item->$iconKey);
                                            @endphp

                                            <a href="{{ $item->$linkKey ?? '#' }}">
                                                <img src="{{ $iconPath }}" alt="social icon" />
                                            </a>
                                        @endforeach

                                    </div>
                                </div>
                            @endif


                            @if (count($footerLinks))
                                <ul class="footer__link ">
                                    @foreach ($footerLinks as $item)
                                        @foreach ($item as $key => $value)
                                            @if (Str::startsWith($key, 'content'))
                                                @php
                                                    $linkKey = 'link' . substr($key, -1);
                                                    $link = $item->$linkKey ?? '#';
                                                @endphp
                                                <li><a href="{{ $link }}">{{ $value }}</a></li>
                                            @endif
                                        @endforeach
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                    @endif

                    @if ($footerText)
                        <div class="footer__copyright mt-3">
                            <p>{{ $footerText }}</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </footer>

    <!-- Footer Section End -->

    <!-- Header menu Flyout -->
    {{-- <div class="custom__offcanvas offcanvas offcanvas-start" tabindex="-1" id="headerOffcanvas">
            <!-- Haeder Start -->
            <div class="offcanvas__header">
                <div class="brand-logo">
                    <a href="index.html">
                        <img src="assets/images/logo/logo.svg" alt="logo" />
                    </a>
                </div>
                <button type="button" class="btn__close" data-bs-dismiss="offcanvas">
                    <i class="ri-close-large-line"></i>
                </button>
            </div>
            <!-- Haeder End -->
            <div class="offcanvas__body p-0">
                <ul class="offcanvas-nav-menu">
                    <li><a href="index.html">Home</a></li>
                    <li><a href="#">About us</a></li>
                    <li><a href="#">Contact Us</a></li>
                    <li><a href="#">Privacy Policy</a></li>
                    <li class="btn__group">
                        <a href="#" class="rs-btn rs-btn-primary">Get The App</a>
                        <a href="{{ route('dashboard')}}" class="rs-btn rs-btn-outline">Go to Admin</a>
                    </li>
                </ul>
            </div>
        </div> --}}
    <!-- Header menu Flyout -->

    <!-- JS -->
    <script src="assets/js/jquery-3.7.1.min.js"></script>
    <!-- bootstrap js -->
    <script src="assets/js/bootstrap.min.js"></script>
    <!-- swiper slider -->
    <script src="assets/js/swiper-bundle.min.js"></script>
    <!-- Aos animation -->
    <script src="assets/js/aos.js"></script>
    <!-- Smooth Scroll -->
    <script src="assets/js/smooth-scroll.js"></script>
    <!-- main js -->
    <script src="assets/js/scripts.js"></script>
</body>

</html>
