<?php

namespace App\Services;

use App\Models\PaymentGateway;
use Yabacon\Paystack;

class PaystackService
{
    protected $publicKey;
    protected $secretKey;

    public function __construct()
    {
        $paymentMethod = PaymentGateway::where('type', 'paystack')->first();

        if ($paymentMethod) {
            $config = json_decode($paymentMethod->config);
            $this->publicKey = $config->public_key ?? null;
            $this->secretKey = $config->secret_key ?? null;
        }
    }

    public function paymentSuccess($order, $user, $amount)
    {
        $successUrl = route('payment.success');
        $cancelUrl  = route('payment.cancel');

        if (!$this->publicKey || !$this->secretKey) {
            return response()->json([
                'message' => 'Paystack credentials are not configured.'
            ], 400);
        }

        try {
            $callbackUrl = $successUrl . '?' . http_build_query([
                'payment' => 'paystack',
                'order_id' => $order->id,
            ]);

            $amountInKobo = (int) ($amount * 100);

            $paystack = new Paystack($this->secretKey);

            $tranx = $paystack->transaction->initialize([
                'amount'       => $amountInKobo,
                'email'        => $user->email,
                'callback_url' => $callbackUrl,
                'metadata'     => [
                    'order_id' => $order->id,
                    'user_id'  => $user->id,
                ],
            ]);

            if (!$tranx->status) {
                return $tranx->message ?? 'Unable to initialize payment.';
            }

            // Return the payment URL to redirect user
            return $tranx->data->authorization_url;

        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
}
